#include <windows.h>
#include "resource.h"
#include "debug.h"


LRESULT CALLBACK WndProc (HWND, UINT, WPARAM, LPARAM);
int Setup_Window();
int PaintWindow(HWND hwnd, HDC hdc);
int Line(int x, int y, int x2, int y2, HDC hdc);
int CheckMove(int x,int y);

int Puzzle[4][4];
int win;
int CloseColor;
int MinColor;
HWND hwnd;
WNDCLASS wndclass ;
HINSTANCE hInstanceG;
HBITMAP wbBitmap;
HBITMAP PuzzleBitmap;
TCHAR szAppName[] = TEXT ("Puzzle") ;

int WINAPI WinMain (HINSTANCE hInstance, HINSTANCE hPrevInstance,
                    PSTR szCmdLine, int iCmdShow){
	int i,j,t=0;

	MSG msg ;

	hInstanceG = hInstance;

	srand(time(0));
	for (i=0;i<4;i++)
		for(j=0;j<4;j++){
			Puzzle[i][j]=t;
			t++;
		}

	for(i=0;i<50000;i++){
		CheckMove((int) ( ((double)rand()/RAND_MAX) *4),(int) ( ((double)rand()/RAND_MAX) *4));
	}
	win=0;
	CloseColor=0;
	MinColor=0;
	init_debug();

	if(!Setup_Window()){
		stop_debug();
		return 0;
	}
	wbBitmap = LoadBitmap(hInstance,IDB_WB);
	PuzzleBitmap = LoadBitmap(hInstance,IDB_DEFAULT_PUZZLE);
	ShowWindow (hwnd, iCmdShow) ;
	UpdateWindow (hwnd) ;
     
	while (GetMessage (&msg, NULL, 0, 0)){
		TranslateMessage (&msg) ;
		DispatchMessage (&msg) ;
	}

	DeleteObject (wbBitmap);
	stop_debug();

	return msg.wParam ;
}

LRESULT CALLBACK WndProc (HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam){

	static int MoveWindow = 0;
	static int x,y,clo=0,min=0;
	int xtemp,ytemp,i,j,t;
	HDC hdc,hdcbuffer;
	HBITMAP buffer;
	PAINTSTRUCT ps;
	WINDOWPLACEMENT winLoc;
	RECT rect;
	


	switch (message){
		case WM_CREATE:
			return 0;

		case WM_PAINT:
			hdc = BeginPaint (hwnd, &ps);
			GetClientRect (hwnd, &rect);
			buffer = CreateCompatibleBitmap(hdc,rect.right,rect.bottom);
			hdcbuffer = CreateCompatibleDC(hdc);
			SelectObject(hdcbuffer,buffer);
			PaintWindow(hwnd, hdcbuffer);
			BitBlt(hdc,0,0,rect.right+1,rect.bottom+1,hdcbuffer,0,0,SRCCOPY);
			DeleteObject(buffer);
			DeleteObject(hdcbuffer);
			EndPaint (hwnd, &ps);
			return 0;

		case WM_LBUTTONDOWN:
			GetClientRect (hwnd, &rect);
			x = (short)LOWORD(lParam);
			y = (short)HIWORD(lParam);
			if(y<22){
				if ((x>rect.right-40)&&(x<rect.right-25)){
					CloseWindow(hwnd);
					dprintf("Minimize\n");
				}
				else if ((x>rect.right-20)&&(x<rect.right-5)){
					DestroyWindow(hwnd);
					dprintf("quit\n");
				}
				else{
					dprintf("Title Bar\n");
					MoveWindow = 1;
				}
			}
			else if ((y>24)&&(x>2)&&(x<203)&&(!win)){
				dprintf("Square = %d,%d\n",((x-3)/50),((y-24)/38));
				if(CheckMove((x-3)/50,(y-24)/38)){
					t=0;
					for (i=0;i<4;i++)
						for(j=0;j<4;j++){
							if (Puzzle[i][j]==t)
							t++;
						}
	
					if (t==16){
						dprintf("win\n");
						win=1;
					}
					InvalidateRect (hwnd, NULL, FALSE);
				}
			}
			return 0;
		case WM_LBUTTONDBLCLK:
			dprintf("Double Click Detected\n");
			x = (short)LOWORD(lParam);
			y = (short)HIWORD(lParam);
			GetClientRect (hwnd, &rect);
			if(y<22){
				if (rect.bottom > 50)
					SetWindowPos(hwnd,HWND_NOTOPMOST,0,0,207,23,SWP_NOMOVE|SWP_NOZORDER);
				else
					SetWindowPos(hwnd,HWND_NOTOPMOST,0,0,207,176,SWP_NOMOVE|SWP_NOZORDER);
				dprintf("Window Shade\n");
			}
			else if (win==1){
				for(i=0;i<50000;i++){
					CheckMove((int) ( ((double)rand()/RAND_MAX) *4),(int) ( ((double)rand()/RAND_MAX) *4));
				}
				win=0;
				InvalidateRect (hwnd, NULL, FALSE);
			}
			return 0;

		case WM_LBUTTONUP:
			MoveWindow = 0;
			return 0;
		
		case WM_MOUSEMOVE:
			SetCapture(hwnd);
			xtemp = (short)LOWORD(lParam);
			ytemp = (short)HIWORD(lParam);
			GetClientRect (hwnd, &rect);

			if(MoveWindow){
				GetWindowPlacement(hwnd, &winLoc);
				SetWindowPos(hwnd,HWND_NOTOPMOST,winLoc.rcNormalPosition.left + xtemp - x,
				winLoc.rcNormalPosition.top + ytemp - y,0,0,SWP_NOSIZE);
				return 0;
			}
			else if((xtemp<0)||(ytemp<0)||(xtemp>rect.right)||(ytemp>rect.bottom)){
				ReleaseCapture();
			}

			if ((ytemp>0)&&(ytemp<22)&&(xtemp>rect.right-40)&&(xtemp<rect.right-25)){
				MinColor = 1;
			}
			else
				MinColor = 0;

			if ((ytemp>0)&&(ytemp<22)&&(xtemp>rect.right-20)&&(xtemp<rect.right-5)){
				CloseColor = 1;
			}
			else{
				CloseColor = 0;
			}

			if(clo!=CloseColor){
				clo=CloseColor;
				min=MinColor;
				InvalidateRect (hwnd, NULL, FALSE);
			}
			else if (min!=MinColor){
				min=MinColor;
				InvalidateRect (hwnd, NULL, FALSE);
			}
			return 0;
		case WM_COMMAND:
			if (!HIWORD(wParam)){
				switch(LOWORD(wParam)){
				case 61472: // Minimize
					dprintf("WM_COMMAND 61472 Minimize \n");
					CloseWindow(hwnd);
					break;
				case 61536: //Close
					dprintf("WM_COMMAND Close 61536 \n");
					break;
				default:
					break;
				}
			}
			return 0;
		case WM_DESTROY:
			PostQuitMessage (0);
			return 0;
	}

	return DefWindowProc (hwnd, message, wParam, lParam) ;
}

int CheckMove(int x,int y){
	int i;
	if((x>3)||(y>3)||(x<0)||(y<0))
		return 0;

	if(Puzzle[x][y]==15)
		return 0;

	if(x<3){
		i = x;
		while(i<3){
			i++;
			if(Puzzle[y][i]==15){
				while(i!=x){
					i--;
					Puzzle[y][i+1] = Puzzle[y][i];
				}
				Puzzle[y][x] = 15;
				return 1;
			}
		}
	}
	if(y<3){
		i = y;
		while(i<3){
			i++;
			if(Puzzle[i][x]==15){
				while(i!=y){
					i--;
					Puzzle[i+1][x] = Puzzle[i][x];
				}
				Puzzle[y][x] = 15;
				return 1;
			}
		}
	}

	if(x>0){
		i = x;
		while(i>0){
			i--;
			if(Puzzle[y][i]==15){
				while(i!=x){
					i++;
					Puzzle[y][i-1] = Puzzle[y][i];
				}
				Puzzle[y][x] = 15;
				return 1;
			}
		}
	}

	if(y>0){
		i = y;
		while(i>0){
			i--;
			if(Puzzle[i][x]==15){
				while(i!=y){
					i++;
					Puzzle[i-1][x] = Puzzle[i][x];
				}
				Puzzle[y][x] = 15;
				return 1;
			}
		}
	}

	return 0;
}

int Line(int x, int y, int x2, int y2, HDC hdc){
	MoveToEx(hdc,x,y,NULL);
	LineTo(hdc,x2,y2);
	return 1;
}

int PaintWindow(HWND hwnd, HDC hdc){
	RECT rect;
	HBRUSH BackColor;
	HPEN CurrentPen, tempPen;
	HDC temp;
	int i,j,t,puzz;
	
	temp = CreateCompatibleDC(hdc);

	BackColor = CreateSolidBrush(RGB(239,239,239));
	GetClientRect (hwnd, &rect);
	FillRect(hdc,&rect,BackColor);
	DeleteObject(BackColor);

	CurrentPen = CreatePen(PS_SOLID,0,RGB(63,72,95));
	tempPen = SelectObject(hdc, CurrentPen);	
	Line(rect.left,rect.top,rect.left,rect.bottom,hdc);
	Line(rect.left,rect.bottom-1,rect.right,rect.bottom-1,hdc);
	Line(rect.right-1,rect.top,rect.right-1,rect.bottom,hdc);
	SelectObject(hdc, tempPen);
	DeleteObject(CurrentPen);

	CurrentPen = CreatePen(PS_SOLID,0,RGB(144,144,144));//1
	tempPen = SelectObject(hdc, CurrentPen);
	Line(rect.left+1,rect.top,rect.right - 1,rect.top,hdc);
	SelectObject(hdc, tempPen);
	DeleteObject(CurrentPen);

	CurrentPen = CreatePen(PS_SOLID,0,RGB(240,255,255));//2
	tempPen = SelectObject(hdc, CurrentPen);
	Line(rect.left+1,rect.top+1,rect.right - 1,rect.top+1,hdc);
	SelectObject(hdc, tempPen);
	DeleteObject(CurrentPen);

	CurrentPen = CreatePen(PS_SOLID,0,RGB(255,248,255)); //3,11
	tempPen = SelectObject(hdc, CurrentPen);
	Line(rect.left+1,rect.top+2,rect.right - 1,rect.top+2,hdc);
	Line(rect.left+1,rect.top+10,rect.right - 1,rect.top+10,hdc);
	SelectObject(hdc, tempPen);
	DeleteObject(CurrentPen);

	CurrentPen = CreatePen(PS_SOLID,0,RGB(224,231,224)); //5,9,14,16
	tempPen = SelectObject(hdc, CurrentPen);
	Line(rect.left+1,rect.top+4,rect.right - 1,rect.top+4,hdc);
	Line(rect.left+1,rect.top+8,rect.right - 1,rect.top+8,hdc);
	Line(rect.left+1,rect.top+13,rect.right - 1,rect.top+13,hdc);
	Line(rect.left+1,rect.top+15,rect.right - 1,rect.top+15,hdc);
	SelectObject(hdc, tempPen);
	DeleteObject(CurrentPen);

	CurrentPen = CreatePen(PS_SOLID,0,RGB(255,255,255));//7
	tempPen = SelectObject(hdc, CurrentPen);
	Line(rect.left+1,rect.top+6,rect.right - 1,rect.top+6,hdc);
	SelectObject(hdc, tempPen);
	DeleteObject(CurrentPen);

	CurrentPen = CreatePen(PS_SOLID,0,RGB(255,248,255)); //11,19
	tempPen = SelectObject(hdc, CurrentPen);
	Line(rect.left+1,rect.top+10,rect.right - 1,rect.top+10,hdc);
	Line(rect.left+1,rect.top+18,rect.right - 1,rect.top+18,hdc);
	SelectObject(hdc, tempPen);
	DeleteObject(CurrentPen);

	CurrentPen = CreatePen(PS_SOLID,0,RGB(224,224,224));//13
	tempPen = SelectObject(hdc, CurrentPen);
	Line(rect.left+1,rect.top+12,rect.right - 1,rect.top+12,hdc);
	SelectObject(hdc, tempPen);
	DeleteObject(CurrentPen);

	CurrentPen = CreatePen(PS_SOLID,0,RGB(240,247,240));//15
	tempPen = SelectObject(hdc, CurrentPen);
	Line(rect.left+1,rect.top+14,rect.right - 1,rect.top+14,hdc);
	SelectObject(hdc, tempPen);
	DeleteObject(CurrentPen);

	CurrentPen = CreatePen(PS_SOLID,0,RGB(223,216,223));//17
	tempPen = SelectObject(hdc, CurrentPen);
	Line(rect.left+1,rect.top+16,rect.right - 1,rect.top+16,hdc);
	SelectObject(hdc, tempPen);
	DeleteObject(CurrentPen);

	CurrentPen = CreatePen(PS_SOLID,0,RGB(223,223,223));//18
	tempPen = SelectObject(hdc, CurrentPen);
	Line(rect.left+1,rect.top+17,rect.right - 1,rect.top+17,hdc);
	SelectObject(hdc, tempPen);
	DeleteObject(CurrentPen);

	CurrentPen = CreatePen(PS_SOLID,0,RGB(208,215,208));//20  loop
	tempPen = SelectObject(hdc, CurrentPen);
	Line(rect.left+1,rect.top+19,rect.right - 1,rect.top+19,hdc);

	Line(rect.left+2,rect.top+24,rect.right - 3,rect.top+24,hdc);
	Line(rect.left+2,rect.top+24,rect.left+2,rect.bottom-1,hdc);
	Line(rect.right - 2,rect.top+23,rect.right - 2,rect.bottom-1,hdc);
	SelectObject(hdc, tempPen);
	DeleteObject(CurrentPen);

	CurrentPen = CreatePen(PS_SOLID,0,RGB(207,200,207));//21
	tempPen = SelectObject(hdc, CurrentPen);
	Line(rect.left+1,rect.top+20,rect.right - 1,rect.top+20,hdc);
	SelectObject(hdc, tempPen);
	DeleteObject(CurrentPen);

	CurrentPen = CreatePen(PS_SOLID,0,RGB(207,207,207));//22
	tempPen = SelectObject(hdc, CurrentPen);
	Line(rect.left+1,rect.top+21,rect.right - 1,rect.top+21,hdc);
	SelectObject(hdc, tempPen);
	DeleteObject(CurrentPen);

	CurrentPen = CreatePen(PS_SOLID,0,RGB(112,112,111));//23
	tempPen = SelectObject(hdc, CurrentPen);
	Line(rect.left+1,rect.top+22,rect.right - 1,rect.top+22,hdc);
	SelectObject(hdc, tempPen);
	DeleteObject(CurrentPen);

	CurrentPen = CreatePen(PS_SOLID,0,RGB(175,168,160));
	tempPen = SelectObject(hdc, CurrentPen);
	Line(rect.left+1,rect.top+23,rect.right - 3,rect.top+23,hdc);
	Line(rect.left+1,rect.top+23,rect.left+1,rect.bottom-1,hdc);
	Line(rect.right - 3,rect.top+23,rect.right - 3,rect.bottom-1,hdc);
	SelectObject(hdc, tempPen);
	DeleteObject(CurrentPen);

	SelectObject(temp, wbBitmap);
	
	if(CloseColor)
		BitBlt(hdc,rect.right-20,4,15,15,temp,0,16,SRCCOPY); //X Close Window
	else
		BitBlt(hdc,rect.right-20,4,15,15,temp,0,0,SRCCOPY);
	
	if(MinColor)
		BitBlt(hdc,rect.right-40,4,15,15,temp,0,48,SRCCOPY); //- Minize
	else
		BitBlt(hdc,rect.right-40,4,15,15,temp,0,0,SRCCOPY);

	//Puzzle
	SelectObject(temp, PuzzleBitmap);
	CurrentPen = CreatePen(PS_SOLID,0,RGB(0,0,0));
	tempPen = SelectObject(hdc, CurrentPen);

	if (win){
		BitBlt(hdc,3,25,200,150,temp,0,0,SRCCOPY);
	}
	else {
		t=0;
		for(j=0;j<4;j++){
			for(i=0;i<4;i++){
				puzz = Puzzle[j][i];
				if(puzz!=15)
					BitBlt(hdc,3+50*i,25+t,50,37,temp,0+((puzz%4)*50),0+((puzz/4)*37),SRCCOPY);
				else
					BitBlt(hdc,3+50*i,25+t,50,37,temp,0+((puzz%4)*50),0+((puzz/4)*37),BLACKNESS);
			}
			if(j>1)
				t+=38;
			else
				t+=37;
		}
		for(i=0;i<4;i++){
			Line(53+50*i,25,53+50*i,175,hdc);
		}
		Line(3,61,203,61,hdc);
		Line(3,98,203,98,hdc);
		Line(3,136,203,136,hdc);
		Line(3,174,203,174,hdc);
	}

	SelectObject(hdc, tempPen);
	DeleteObject(CurrentPen);
	DeleteDC(temp);
	return 1;
}

int Setup_Window(){
	wndclass.style         = CS_HREDRAW | CS_VREDRAW | CS_DBLCLKS;
	wndclass.lpfnWndProc   = WndProc ;
	wndclass.cbClsExtra    = 0 ;
	wndclass.cbWndExtra    = 0 ;
	wndclass.hInstance     = hInstanceG ;
	wndclass.hIcon         = LoadIcon (hInstanceG, IDI_PUZZLE);
	wndclass.hCursor       = LoadCursor (NULL, IDC_ARROW) ;
	wndclass.hbrBackground = (HBRUSH) GetStockObject (WHITE_BRUSH) ;
	wndclass.lpszMenuName  = NULL ;
	wndclass.lpszClassName = szAppName ;

	if (!RegisterClass (&wndclass)){
		MessageBox (NULL, TEXT ("This program refuses to work on this computer"), 
					szAppName, MB_ICONERROR) ;
		return 0 ;
	}

	hwnd = CreateWindow (szAppName,					// window class name
			TEXT ("Puzzle"),						// window caption
			WS_POPUP | WS_VISIBLE | WS_SYSMENU |WS_MINIMIZEBOX ,	// window style
			200,									// initial x position
			200,									// initial y position
			207,									// initial x size
			176,									// initial y size
			NULL,									// parent window handle
			NULL,									// window menu handle
			hInstanceG,								// program instance handle
			NULL);									// creation parameters
	return 1;
}